/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.cec;

import com.ibm.hsc.auiml.databeans.cec.CUoDProcessorActivateImmediate;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AuimlAdapter;
import com.ibm.hsc.common.util.ErrorPanel;
import com.ibm.hsc.common.util.GeneralUtil;
import com.ibm.hsc.common.util.HMCDynamicPanelManager;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.ui.framework.DataBean;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskActionListener;
import com.ibm.ui.framework.UserTaskManager;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.mobject.MOXContainerObj;
import java.util.Hashtable;
import java.util.Vector;

public class CUoDProcessorActivateImmediateDialog
implements TaskActionListener {
    private UserTaskManager _utm = null;
    private Hashtable _vectors = null;
    private CUoDProcessorActivateImmediate _bean = null;
    Object[] _pInfoArgs = new Object[3];
    MOXContainerObj _obj = null;
    private String _increment = "-1";
    private boolean _isOnOffEnabled = false;
    private boolean _isCurrentlyInUse = false;
    private int _onOffRequested = 0;

    public void showDialog(MOXContainerObj mOXContainerObj) {
        this._obj = mOXContainerObj;
        this._bean = new CUoDProcessorActivateImmediate();
        this._bean.load();
        if (!this.setBeanInfo(mOXContainerObj)) {
            return;
        }
        try {
            int n = 0;
            int n2 = 0;
            if (this._isOnOffEnabled) {
                n = this._onOffRequested;
            }
            int n3 = Integer.parseInt(this._bean.getNumProcInstalled());
            int n4 = Integer.parseInt(this._bean.getNumProcPermInUse());
            n2 = n3 - n4;
            if (IDebug.enabled) {
                System.err.println(" Is On/Off Enabled  " + this._isOnOffEnabled);
                System.err.println(" On/Off Requested  " + this._onOffRequested);
                System.err.println(" Num Proc Installed " + n3);
                System.err.println(" Num Proc Perm In Use " + n4);
            }
            if (n > 0) {
                n2 -= n;
            }
            if (n2 <= 0) {
                this.showError();
                return;
            }
            DataBean[] dataBeanArray = new DataBean[]{this._bean};
            HMCDynamicPanelManager.setMetalLookAndFeel();
            AuimlAdapter auimlAdapter = new AuimlAdapter("com.ibm.hsc.auiml.databeans.cec.CUoDProcessorActImmedWizard", "ProcAIWizard", dataBeanArray);
            auimlAdapter.init();
            this._utm = auimlAdapter.getUserTaskManager();
            this._utm.addCommitListener((TaskActionListener)this);
            if (this._isOnOffEnabled) {
                this._utm.setEnabled("ProcAIWizardPanel1.NumProcOnOffInUseLabel", true);
                this._utm.setEnabled("ProcAIWizardPanel1.NumProcOnOffInUseString", true);
                this._utm.setEnabled("ProcAIWizardPanel2.NumProcOnOffInUseLabel", true);
                this._utm.setEnabled("ProcAIWizardPanel2.NumProcOnOffInUseCurString", true);
                this._utm.setEnabled("ProcAIWizardPanel2.NumProcOnOffInUseNewString", true);
            }
            this._utm.setAttribute("ProcAIWizardPanel1.NewInUseSpinBox", 29, "" + n2);
            this._utm.setAttribute("ProcAIWizardPanel1.NewInUseSpinBox", 28, "" + this._increment);
            this._utm.setAttribute("ProcAIWizardPanel1.NewInUseSpinBox", 30, "" + this._increment);
            auimlAdapter.showIt();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        CUoDProcessorActivateImmediateDialog cUoDProcessorActivateImmediateDialog = new CUoDProcessorActivateImmediateDialog();
        cUoDProcessorActivateImmediateDialog.showDialog(null);
    }

    private boolean setBeanInfo(MOXContainerObj mOXContainerObj) {
        boolean bl;
        String string;
        int n;
        Hashtable hashtable = null;
        String string2 = (String)mOXContainerObj.getPropertyValue("name");
        String string3 = (String)mOXContainerObj.getPropertyValue("modelType_PROP") + "*" + (String)mOXContainerObj.getPropertyValue("serialNumber_PROP");
        try {
            this._pInfoArgs[0] = string2;
            this._pInfoArgs[1] = mOXContainerObj.getHost().getName();
            this._pInfoArgs[2] = string3;
            hashtable = (Hashtable)mOXContainerObj.getMOClass().invokeStaticMethod("cuodProcessorInfo", this._pInfoArgs);
        }
        catch (Exception exception) {
            if (IDebug.enabled) {
                System.out.println(" Failed to invoke cuodProcessorInfo...");
            }
            String string4 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_PROCESSOR_INFO_ERROR_TITLE");
            HSCLogUtils.clientLog(exception, HSCLogUtils._CECClassLogInfo);
            HSCLogUtils.displayError(exception, string4, HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_PROCESSOR_INFO_ERROR"));
            return false;
        }
        this._increment = (String)hashtable.get("CUOD_PROCESSOR_INCREMENT");
        if (IDebug.enabled) {
            System.err.println("MKS: CUoDProcessorActivateImmediateDialog.setBeanInfo() Increment value -- " + this._increment);
        }
        Vector<MOXContainerObj> vector = new Vector<MOXContainerObj>();
        vector.add(mOXContainerObj);
        this._bean.setNumProcInstalled((String)hashtable.get("CUOD_NUM_CPU_INSTALLED"));
        this._bean.setNumProcPermInUse((String)hashtable.get("CUOD_NUM_CPU_PER_IN_USED"));
        this._bean.setNumProcNotPermInUse((String)hashtable.get("CUOD_NUM_CPU_NOT_PER_IN_USED"));
        this._bean.setIncrementValue(Integer.parseInt(this._increment));
        Short s = (Short)mOXContainerObj.getPropertyValue("cuodCapabilities_PROP");
        if ((s.intValue() & 0x80) == 128) {
            int n2;
            this._isOnOffEnabled = true;
            String string5 = (String)hashtable.get("CUOD_ONOFF_PROCS_IN_USE");
            n = GeneralUtil.getIntValue(string5);
            if (IDebug.enabled) {
                System.err.println(" IN USE procs " + string5);
            }
            string = (String)hashtable.get("CUOD_ONOFF_PROCS_PENDING");
            if (IDebug.enabled) {
                System.err.println(" PENDING procs " + string);
            }
            this._onOffRequested = (n2 = GeneralUtil.getIntValue(string)) > n ? n2 : n;
            this._bean.setNumOnOffProcInUse(this._onOffRequested + "");
        }
        if (!(bl = this.checkForActivateImmediateState(hashtable))) {
            return false;
        }
        try {
            n = Integer.parseInt(this._bean.getNumProcNotPermInUse());
            if (n == 0) {
                this.showError();
                return false;
            }
        }
        catch (Exception exception) {
            string = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_ACTIVATE_IMMEDIATE_NOT_PERM_READ_ERROR", "Not Permanently used value is incorrect");
            String string6 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_ACTIVATE_IMMEDIATE_NOT_PERM_READ_ERROR_TITLE", "Parsing Error");
            ErrorPanel errorPanel = new ErrorPanel(string, string6);
            errorPanel.show();
            return false;
        }
        return true;
    }

    private void showError() {
        String string = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_ACTIVATE_IMMEDIATE_NOT_PERM_HAS_ZERO_ERROR", "There are ZERO permanently not used CPUs. This task is not valid");
        String string2 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_ACTIVATE_IMMEDIATE_ERROR_TITLE", "Trial CoD Error");
        ErrorPanel errorPanel = new ErrorPanel(string, string2);
        errorPanel.show();
    }

    public void actionPerformed(TaskActionEvent taskActionEvent) {
        String string = taskActionEvent.getActionCommand();
        if (string.equals("ACTIVATED")) {
            if (this._utm == null) {
                this._utm = (UserTaskManager)taskActionEvent.getSource();
            }
            if (this._utm != null) {
                this._utm.refreshElement("ProcAIWizardPanel2.NumProcPermImmNewString");
            }
        } else if (string.equals("COMPLETE")) {
            if (this._isCurrentlyInUse) {
                return;
            }
            this._isCurrentlyInUse = true;
            try {
                Object[] objectArray = new Object[4];
                int n = (int)this._bean.getNumProcImmInUseNewSpinVal();
                objectArray[0] = this._pInfoArgs[0];
                objectArray[1] = new Integer(n);
                objectArray[2] = this._pInfoArgs[1];
                objectArray[3] = this._pInfoArgs[2];
                if (IDebug.enabled) {
                    System.err.println("Arguments are: ");
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        System.err.println(" Arg " + n2 + " -- " + objectArray[n2]);
                        ++n2;
                    }
                }
                this._obj.getMOClass().invokeStaticMethod("activateImmedCPU", objectArray);
            }
            catch (Throwable throwable) {
                if (IDebug.enabled) {
                    throwable.printStackTrace();
                }
                this._isCurrentlyInUse = false;
                String string2 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_ACTIVATE_IMMEDIATE_ERROR_TITLE");
                String string3 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_ACTIVATE_IMMEDIATE_GENERAL_ERROR");
                GeneralUtil.handleException(throwable, string2, string3);
                return;
            }
            this._isCurrentlyInUse = false;
        }
    }

    private boolean checkForActivateImmediateState(Hashtable hashtable) {
        try {
            int n = Integer.parseInt((String)hashtable.get("CUOD_CPU_ACT_IMMED_CONDITION"));
            String string = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_PROC_ACTIVATE_IMMEDIATE_NOT_STATE_ERROR_TITLE", "Processor Activate Immediate State Error");
            String string2 = null;
            if ((n & 0xFFFF) == 128) {
                string2 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_PROC_ACTIVATE_IMMEDIATE_IN_USE", "A Trial CoD is currently in use.  You cannot perform another Trial CoD operation.");
            } else if ((n & 0xFFFF) == 255) {
                string2 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_PROC_ACTIVATE_IMMEDIATE_NOLONGER_ALLOWED", "A Trial CoD processor capability has been used and is no longer allowed.");
            } else if ((n & 0xFFFF) != 1) {
                string2 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_PROC_ACTIVATE_IMMEDIATE_UNKNOWN_STATE", "Unknown Trial CoD processor state from CSP");
            }
            if (string2 != null) {
                ErrorPanel errorPanel = new ErrorPanel(string2, string);
                errorPanel.show();
            }
            return string2 == null;
        }
        catch (Exception exception) {
            String string = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_PROC_ACTIVATE_IMMEDIATE_STATE_ERROR", "Incorrect Trial CoD state value.");
            String string3 = HSCResourceBundleUtil.getMessage("CECBundle", "CUOD_PROC_ACTIVATE_IMMEDIATE_NOT_STATE_ERROR_TITLE", "Trial CoD Processor State Error");
            ErrorPanel errorPanel = new ErrorPanel(string, string3);
            errorPanel.show();
            return false;
        }
    }
}

